local assets=
{
	Asset("ANIM", "anim/soul.zip"),
	Asset("IMAGE", "images/inventoryimages/soul.tex"),
	Asset("ATLAS", "images/inventoryimages/soul.xml"),
}


local function healowner(inst, owner)
    if (owner.components.health and owner.components.health:IsHurt()) then
        owner.components.health:DoDelta(1,1)
end
end

local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-1,-1)
end
end

local function onequip(inst, owner) 
    if owner:HasTag("antirad") then
	owner.AnimState:OverrideSymbol("swap_body", "soul", "swap_body")
	inst.task = inst:DoPeriodicTask(60, healowner, nil, owner)
	owner:AddTag("rad")

	else
	owner.AnimState:OverrideSymbol("swap_body", "soul", "swap_body")
	inst.task = inst:DoPeriodicTask(4, hurtowner, nil, owner)
	owner:AddTag("rad")

	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("rad")

	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("soul")
    inst.AnimState:SetBuild("soul")
    inst.AnimState:PlayAnimation("idle", false)
    	
    inst:AddComponent("inspectable")
	
	inst:AddTag("backpack")

	
	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/soul.xml"
    
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 9
	
	
    return inst
end

return Prefab( "common/inventory/soul", fnab, assets) 